<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Inherits="Voxco.Reporting.DnisFilter" Theme="Voxco"
    Title="<%$ Resources:Resource, VoxcoReporting%>" EnableSessionState="True" Trace="false" Async="true" Codebehind="DnisFilter.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">

<telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
	<script type="text/javascript">
	   
			function treeSelectedDropTest(source, dest, events)
			{
				if(dest!= null && dest.Value.substring(0, 3) == "OG:" && source.Parent != null && source.Parent.Value != dest.Value)
				{
					return true;
				}
				// allow moving all group's elements in another group
				if(dest!= null && source.Value.substring(0, 3) == "OG:" && dest.Value.substring(0, 3) == "OG:")
				{
					return true;
				}
				return false;
			}
	        
			function ContextMenuClick(node, itemText)
			{
				if (itemText == "Disable")
				{
					node.Disable();
					return false;
				}
				if (itemText == "Enable All")
				{
					for (var i=0; i<node.TreeView.AllNodes.length; i++)
					{
						node.TreeView.AllNodes[i].Enable();
					}
				}
				if (itemText == "Edit")
				{        
					node.StartEdit();
				}
	            
				return true;
			}
	        
			function UpdateAllChildren(nodes, checked)
			{
				for (i=0; i<nodes.length; i++)
				{
					checked ? nodes[i].Check() : nodes[i].UnCheck(); 
					if (nodes[i].Nodes.length > 0)
					{
						UpdateAllChildren(nodes[i].Nodes, checked);    
					}
				}
			}

			function OnCheckedNode(node)
			{
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
			}
	        
			function grdSelectedDnis_OnColumnClick(index)
			{
				if(index == 0)
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("ToggleSelectAllFiltered");
				}
			}
			function grdAvailableDnis_OnColumnClick(index)
			{
				if(index == 0)
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("ToggleSelectAllAvailable");
				}
			}
	        
			var searchValue = null;
			function FindTextBox_OnValueChanged(sender, e)
			{
				searchValue = e.NewValue;
				FindAgent(e.NewValue);
			}
	        
			function FindTextBox_OnButtonClick(sender, e)
			{
				FindAgent(searchValue);
			}

			function FindAgent(value)
			{
				window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("FindAgent:"+value);
	            
				return false;
			}
	        
			function MoveByXPos()
			{
				radprompt('<%= TranslateForJS("MoveCountPrompt") %>', MoveByXPos_PromptCallBack, 500, 50);
				return false;
			}
	        
			function MoveByXPos_PromptCallBack(_moveCount)
			{
				if( _moveCount != null && _moveCount != '' )
				{
					window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("MoveByXPos:" + _moveCount);
				}
			}

			function MoveToLast()
			{
			  window["<%= RadAjaxPanel2.ClientID %>"].AjaxRequest("MoveGroupToLast");
			  return false;
			}
		</script>
	</telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="AvailableDnisListDataSource" runat="server" SelectMethod="GetGenericDnisLists"
        TypeName="Voxco.Reporting.DataSource.Dnis">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" Height="500px" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="RadAjaxPanel2_OnAjaxRequest" CssClass="mainContent">
        
		<telerik:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" Transparency="25" >
			<VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
		</telerik:RadAjaxLoadingPanel>
            
        <asp:RadioButtonList ID="choiceSelectionType" runat="server" Visible="True" RepeatDirection="Horizontal" 
         AutoPostBack="true" OnSelectedIndexChanged="choiceSelectionType_OnSelectedIndexChanged">
            <asp:ListItem Value="AllDnis" Text="<%$ Resources:Resource, AllDnis%>" Selected="True"></asp:ListItem>
            <asp:ListItem Value="SelectDnis" Text="<%$ Resources:Resource, SelectDnis%>"></asp:ListItem>
        </asp:RadioButtonList>
            
        <asp:Panel ID="IncludeAllDnisLabel" runat="server" GroupingText=" ">
			<asp:Label ID="IncludeAllDnisLabel2" runat="server" Text="<%$ Resources:Resource, AllAvailableDnisWillBeSelected %>"></asp:Label>
		</asp:Panel>
			
        <asp:Panel ID="RadSplitter1" runat="server" Height="100%">
            
            <div style="width:45%; height:100%; float: left;">
            				
				<asp:Label ID="TitleAvailableDnis" runat="server" Text="<%$ Resources:Resource, AvailableDnis %>" CssClass="title"></asp:Label>
				
                <telerik:RadGrid ID="grdAvailableDnis" runat="server" EnableViewState="true" Height="360px"
                AllowSorting="false" OnNeedDataSource="grdAvailableDnis_OnNeedDataSource"
                OnPageIndexChanged="grdAvailableDnis_PageIndexChanged" OnDataBound="grdAvailableDnis_OnDataBound"
                AllowMultiRowSelection="True" AutoGenerateColumns="False"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">                    
                    <ClientSettings>
                        <Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="true" />
                        <ClientEvents OnColumnClick="grdAvailableDnis_OnColumnClick" />
                    </ClientSettings>
                    <MasterTableView NoMasterRecordsText="" Width="100%">
                        <SortExpressions>
                            <telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
                        </SortExpressions>
                        <Columns>
                            <telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
                            </telerik:GridBoundColumn>
                            <telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
                                <HeaderStyle Width="10%" HorizontalAlign="Left" />
                                <ItemStyle Width="10%" HorizontalAlign="Left" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, AvailableDnis %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>                   
				</telerik:RadGrid>
       
            </div>
            
            <div style="width: 25px; float: left;">
            
				<asp:Panel ID="RadPaneDnisButtonsCol12" runat="server" Height="360px" HorizontalAlign="Center">				
				<div class="arrows">
					<asp:ImageButton ID="btnAddDnis" runat="server" ImageUrl="~/icons/arrow_right_blue.png" ToolTip="<%$ Resources:Resource, AddSelectedItems %>"  OnClick="btnAddDnis_OnClick" />
					<asp:ImageButton ID="btnRemoveDnis" runat="server" ImageUrl="~/icons/arrow_left_blue.png" ToolTip="<%$ Resources:Resource, RemoveSelectetedItem %>" OnClick="btnRemoveDnis_OnClick" />
				</div>				
				</asp:Panel>
				
            </div>
                 
			<div style="width:45%; height:100%; float: left;">       
				<asp:Label ID="TitleFilteredDnis" runat="server" Text="<%$ Resources:Resource, FilteredDnis %>" CssClass="title"></asp:Label>
            
				<telerik:RadGrid ID="grdSelectedDnis" runat="server" Height="360px" EnableViewState="true"
				AllowSorting="false" OnNeedDataSource="grdSelectedDnis_OnNeedDataSource"
				OnPageIndexChanged="grdSelectedDnis_PageIndexChanged" OnDataBound="grdSelectedDnis_OnDataBound"
				AllowMultiRowSelection="True" AutoGenerateColumns="False"
				EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">                    
					<ClientSettings>
						<Selecting AllowRowSelect="True" UseClientSelectColumnOnly="True" />
						<Scrolling AllowScroll="true" UseStaticHeaders="true" />
						<ClientEvents OnColumnClick="grdSelectedDnis_OnColumnClick" />
					</ClientSettings>
					<MasterTableView NoMasterRecordsText="" Width="100%">
						<SortExpressions>
							<telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
						</SortExpressions>
						<Columns>
							<telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
							</telerik:GridBoundColumn>
							<telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
							</telerik:GridBoundColumn>
							<telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
								<HeaderStyle Width="10%" HorizontalAlign="Left" />
								<ItemStyle Width="10%" HorizontalAlign="Left" />
							</telerik:GridClientSelectColumn>
							<telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, FilteredDnis %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
							</telerik:GridBoundColumn>
							<telerik:GridBoundColumn DataField="Invalid" UniqueName="Invalid" Display="false" ></telerik:GridBoundColumn>
						</Columns>
					</MasterTableView>                    
				</telerik:RadGrid>      
            </div>
		</asp:Panel>
        
    </telerik:RadAjaxPanel>
    
</asp:Content>

